// SpeechInputDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "SpeechInputDlg.h"
#include "IBFlowView.h"
#include "XISLSpeechInputTag.h"
#include "XISLVarList.h"
#include "XISLVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSpeechInputDlg _CAO


CSpeechInputDlg::CSpeechInputDlg(CXISLSpeechInputTag *pTag,CXISLTag *pCurrentTag,CWnd* pParent /*=NULL*/)
	: CDialog(CSpeechInputDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSpeechInputDlg)
	m_strGrmFile = _T("");
	m_strWord = _T("");
	m_strSentence = _T("");
	//}}AFX_DATA_INIT
	m_pParent = NULL;
	m_pInputTag = pTag;
	m_pCurrentTag = pCurrentTag;
}

CSpeechInputDlg::~CSpeechInputDlg()
{
}

void CSpeechInputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpeechInputDlg)
	DDX_Control(pDX, IDC_SPEECH_WORD_LIST, m_lbWordList);
	DDX_Text(pDX, IDC_GRM_FILE_EDIT, m_strGrmFile);
	DDX_Text(pDX, IDC_WORD_EDIT, m_strWord);
	DDX_Text(pDX, IDC_EDIT_SENTENSE, m_strSentence);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSpeechInputDlg, CDialog)
	//{{AFX_MSG_MAP(CSpeechInputDlg)
	ON_BN_CLICKED(IDC_SPEECH_FILE_BUTTON, OnSpeechFileButton)
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, OnButtonRefresh)
	ON_LBN_SELCHANGE(IDC_SPEECH_WORD_LIST, OnSelchangeSpeechWordList)
	ON_LBN_SELCANCEL(IDC_SPEECH_WORD_LIST, OnSelcancelSpeechWordList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CSpeechInputDlg::SetWordList(LPCTSTR lpszFilePrefix)
{
	m_lbWordList.ResetContent();
	CString strName = lpszFilePrefix;
	strName += ".term";
	CStdioFile fin(strName,CFile::modeRead);
	CString strWord = "";
	while(fin.ReadString(strWord) != NULL)
	{
		if(strWord.IsEmpty())
			continue;

		while(!strWord.IsEmpty())
		{
			if(isalpha(strWord[0]))
				break;
			strWord.Delete(0);
		}
		m_lbWordList.AddString(strWord);
	}
	fin.Close();

	m_slWord.RemoveAll();
	CString strVocaName = lpszFilePrefix;
	strVocaName += ".voca";
	CStdioFile fin2(strVocaName,CFile::modeRead);
	strWord = "";
	int nIndex = -1;
	CString strVoca = "";
	while(fin2.ReadString(strWord) != NULL)
	{
		if(strWord.IsEmpty())
			continue;
		if(strWord[0] == '#')
			continue;

		if(strWord[0] == '%')
		{
			strWord += "\r\n";
			m_slWord.AddTail(strWord);
			nIndex++;
			continue;
		}
		strWord += "\r\n";
		POSITION pos = m_slWord.FindIndex(nIndex);
		m_slWord.GetAt(pos) += strWord;
	}
	fin2.Close();

	m_strSentence.Empty();
	m_strWord.Empty();
	UpdateData(FALSE);
}

void CSpeechInputDlg::GenerateSentence(LPCTSTR lpszGrmPath)
{
	//SECURITY_ATTRIBUTEݒ
	SECURITY_ATTRIBUTES securityAttr;
	securityAttr.nLength = sizeof( SECURITY_ATTRIBUTES );
	securityAttr.bInheritHandle = TRUE;
	securityAttr.lpSecurityDescriptor = NULL;
	//Wo͂Ҕ
	HANDLE hSaveStdout = GetStdHandle(STD_OUTPUT_HANDLE);
	HANDLE hSaveStderr = GetStdHandle(STD_ERROR_HANDLE);
	//qvZXւ̃pCvB
	HANDLE hChildStdoutWriteEnd;
	HANDLE hChildStdoutReadEnd;
	if (!CreatePipe(&hChildStdoutReadEnd, &hChildStdoutWriteEnd, &securityAttr, 0)) {
		return;
	}

	//qvZXN
	PROCESS_INFORMATION procInfo;
	STARTUPINFO supInfo;
	ZeroMemory(&procInfo, sizeof(PROCESS_INFORMATION));
	ZeroMemory(&supInfo, sizeof(STARTUPINFO));
	GetStartupInfo(&supInfo);
	supInfo.dwFlags		= STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
	supInfo.wShowWindow = SW_SHOWMINNOACTIVE;
//	supInfo.wShowWindow = SW_MINIMIZE;
	supInfo.hStdOutput	= hChildStdoutWriteEnd;
	supInfo.hStdError	= hChildStdoutWriteEnd;

	CWinApp *pApp = AfxGetApp();
	CString strExe = pApp->GetProfileString("SRM","Generate",NULL);

//	CString strExe = "D:\\IPA\\engine\\SRM\\Galatea_SRM\\bin\\generate.exe ";
	strExe += " ";
	strExe += lpszGrmPath;
//	strExe += " D:\\vO\\IPA\\SRM\\Galatea_SRM_Windows_alpha_021121\\GramJulian\\vfr\\vfr";

	if (!CreateProcess(NULL,
		strExe.GetBuffer(strExe.GetLength()),
		NULL, NULL, TRUE, 0, NULL, NULL,
		&supInfo,
		&procInfo))
	{
		m_strSentence = "Can't execute! \"generate.exe\" ";
		UpdateData(FALSE);
		return;
	}

	// ̃vZX̕Wo͂ɖ߂B
	if (!SetStdHandle(STD_OUTPUT_HANDLE, hSaveStdout)) {
		m_strSentence = "Can't Set StdHandle";
		UpdateData(FALSE);
		return;
	}
	if (!SetStdHandle(STD_ERROR_HANDLE, hSaveStderr)) {
		m_strSentence = "Can't Set StdHandle";
		UpdateData(FALSE);
		return;
	}
	//pCvǂݍޑOɏݒ[B
	if ( !CloseHandle( hChildStdoutWriteEnd ) ){
		m_strSentence = "Can't close handle";
		UpdateData(FALSE);
		return;
	}

	//ǂݍ݂̃[v
	CString strResult;
	const	int		BUFSIZE = 16384;
	char	sBuffer[BUFSIZE];
	DWORD	dwRead;
	for (;;){
		if (!ReadFile(hChildStdoutReadEnd, sBuffer, BUFSIZE-1, &dwRead, NULL) || dwRead == 0) {
			break;
		} else {
			sBuffer[dwRead] = '\0';
			strResult += sBuffer;
		}
	}

	int nIndex = strResult.Find("---");
	if(nIndex != -1)
	{
		strResult.Delete(0,nIndex);

		m_strSentence += strResult;
		m_strSentence.Replace("silB","");
		m_strSentence.Replace("silE","");

		nIndex = m_strSentence.Find("Reading",nIndex);
		if(nIndex != -1)
			m_strSentence.Delete(nIndex,m_strSentence.GetLength()-nIndex);

		m_strSentence.Replace("\n","\r\n");
	}
	else
		m_strSentence = "s";


	UpdateData(FALSE);

	// vZX̃^[R[h𒲂ׂ
//	GetExitCodeProcess(procInfo.hProcess, &pParam->dwReturnCode);
}

void CSpeechInputDlg::SetWord()
{	
	UpdateData();

	int *pIndex;
	m_nSelCnt = m_lbWordList.GetSelCount();
	pIndex = new int[m_nSelCnt];
	m_lbWordList.GetSelItems(m_nSelCnt,pIndex);

	m_strWord.Empty();
	for(int i=0; i<m_nSelCnt; i++)
	{
		POSITION pos = m_slWord.FindIndex(pIndex[i]);
		m_strWord += m_slWord.GetAt(pos);
	}
	delete pIndex;

	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// CSpeechInputDlg bZ[W nh

void CSpeechInputDlg::OnSpeechFileButton()
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CFileDialog fileDlg(TRUE,"grammar","*.grammar",OFN_OVERWRITEPROMPT,
		"@t@C(*.grammar)|*.grammar");

	if(fileDlg.DoModal() != IDOK)
		return;
	
	m_strGrmFile = fileDlg.GetPathName();
	int nDot = m_strGrmFile.ReverseFind('.');
	m_strGrmFile = m_strGrmFile.Left(nDot);
	SetWordList(m_strGrmFile);
	GenerateSentence(m_strGrmFile);
	UpdateData(FALSE);
}

void CSpeechInputDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	int *pIndex;
	CString strData;
		
	UpdateData();

	//Iꂽڂ擾
	m_nSelCnt = m_lbWordList.GetSelCount();
	pIndex = new int[m_nSelCnt];
	m_lbWordList.GetSelItems(m_nSelCnt,pIndex);
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	for(int i=0; i<m_nSelCnt; i++)
	{
		m_lbWordList.GetText(pIndex[i],strData);
		CXISLVar *pVar = pExcItem->m_pLocalVar->FindVar(strData);
		if(pVar==NULL)
		{
			pVar = new CXISLVar;
			if(pVar->SetAttribute(strData,"",FALSE,FALSE) != 0)
			{
				delete pVar;
				delete pIndex;
				return;
			}
			if(pExcItem->m_pLocalVar->RegistVar(pVar) != 0)
			{
				delete pVar;
				delete pIndex;
				return;
			}
		}
		this->m_ReturnVarList.AddTail(pVar);
	}
	delete pIndex;

	m_pInputTag->m_ReturnVarList.RemoveAll();
	POSITION pos = this->m_ReturnVarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)this->m_ReturnVarList.GetNext(pos);
		m_pInputTag->m_ReturnVarList.AddTail(pVar);
		pVar->ReferCount(TRUE);
	}


	m_pInputTag->SetAttribute(m_strGrmFile);

	CDialog::OnOK();
}

void CSpeechInputDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	POSITION pos = m_pInputTag->m_ReturnVarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_pInputTag->m_ReturnVarList.GetNext(pos);
		pVar->ReferCount(TRUE);
	}

	CDialog::OnCancel();
}

BOOL CSpeechInputDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_strGrmFile = m_pInputTag->GetGrmFile();
	if(m_strGrmFile.IsEmpty())
		return TRUE;


	SetWordList(m_strGrmFile);

	POSITION pos = m_pInputTag->m_ReturnVarList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_pInputTag->m_ReturnVarList.GetNext(pos);
		CString strName = pVar->GetVarName();
		m_lbWordList.SetSel(m_lbWordList.FindString(-1,strName));
		pVar->ReferCount(FALSE);
	}

	SetWord();
	GenerateSentence(m_strGrmFile);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}



void CSpeechInputDlg::OnButtonRefresh() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	m_strSentence.Empty();
	GenerateSentence(m_strGrmFile);
}

void CSpeechInputDlg::OnSelchangeSpeechWordList() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetWord();
}

void CSpeechInputDlg::OnSelcancelSpeechWordList() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	SetWord();
}

